package com.RT_Printer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

import com.RT_Printer.WIFI.WifiPrintDriver;
import com.RT_Printer.util.Utils;
import android.app.Activity;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;

public class PrinterOptionActivity extends Activity{
	private Button mBtnBack = null;
	private Button mBtnPrintText = null;
	private Button mBtnPrintImage = null;
	private Button mBtnPrint1DBarcode = null;
	private Button mBtnPrintTicket = null;
	private Button mBtnPrintTable = null;
	private EditText m1DBarcodeContent = null;
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.printer_option);
        InitUIControl();
    }



	@Override
	protected void onResume() {
//		this.mBloothPrinter = BloothPrinterActivity.mBloothPrinter;
		super.onResume();
	}

	
	private String getLanguageEnv() {  
	       Locale l = Locale.getDefault();  
	       String language = l.getLanguage();  
	       String country = l.getCountry().toLowerCase();  
	       if ("zh".equals(language)) {  
	           if ("cn".equals(country)) {  
	               language = "zh-CN";  
	           } else if ("tw".equals(country)) {  
	               language = "zh-TW";  
	           }  
	       } else if ("pt".equals(language)) {  
	           if ("br".equals(country)) {  
	               language = "pt-BR";  
	           } else if ("pt".equals(country)) {  
	               language = "pt-PT";  
	           }  
	       }  
	       return language;  
	}  


	private void InitUIControl(){
    	mBtnBack = (Button)findViewById(R.id.btn_back);
    	mBtnBack.setOnClickListener(mBtnBackOnClickListener);
    	mBtnPrintText = (Button)findViewById(R.id.btn_print_text);
    	mBtnPrintText.setOnClickListener(mBtnPrintTextOnClickListener);
    	mBtnPrintImage = (Button)findViewById(R.id.btn_print_image);
    	mBtnPrintImage.setOnClickListener(mBtnPrintImageOnClickListener);
    	mBtnPrint1DBarcode = (Button)findViewById(R.id.btn_print_barcode);
    	mBtnPrint1DBarcode.setOnClickListener(mBtnPrint1DBarcodeOnClickListener);
    	mBtnPrintTicket = (Button)findViewById(R.id.btn_print_smallticket);
    	mBtnPrintTicket.setOnClickListener(mBtnPrintTicketOnClickListener);
    	mBtnPrintTable = (Button)findViewById(R.id.btn_print_table);
    	mBtnPrintTable.setOnClickListener(mBtnPrintTableOnClickListener);
    	m1DBarcodeContent = (EditText)findViewById(R.id.edt_barcode_content);
    }

	OnClickListener mBtnBackOnClickListener = new OnClickListener() {
		@Override
		public void onClick(View v) {
			finish();
		}
	};

	OnClickListener mBtnPrintTextOnClickListener = new OnClickListener() {
		@Override
		public void onClick(View v) {
			if(WifiPrintDriver.IsNoConnection()){
				return;
			}
			WifiPrintDriver.Begin();

			String tmpString = PrinterOptionActivity.this.getResources().getString(R.string.print_text_content);
			WifiPrintDriver.ImportData(tmpString);
			WifiPrintDriver.ImportData("\r");
			WifiPrintDriver.LF();
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
		}
	};

	OnClickListener mBtnPrintImageOnClickListener = new OnClickListener() {
		@Override
		public void onClick(View v) {
			if(WifiPrintDriver.IsNoConnection()){
				return;
			}
			InputStream in = null;
			try {
				in = getResources().getAssets().open("Rongta.jpg");
			} catch (IOException e) {
				e.printStackTrace();
			}
			/**
			 * ˵£ͬͼƬʹBitmapFactory.decodeResource(res, id);
			 * Bitmap λͼ߶ԭͼ2ʹȡķʽԴļжȡ
			 *	ҰͼƬΪ ߶Ϊ 322СءҪעһ
			 *
			 */
/*			BufferedInputStream bis = new BufferedInputStream(in);
			Bitmap bitmap = BitmapFactory.decodeStream(bis);
			//ʹӡͼƬǰָ
			byte[] start = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x40, 0x1B, 0x33, 0x00 };
			mBloothPrinter.Begin();
			mBloothPrinter.ImportData(start, start.length);
			mBloothPrinter.excute();
			mBloothPrinter.ClearData();
			//ͼƬ
			byte[] byteImage = Utils.getReadBitMapBytes(bitmap);		
			mBloothPrinter.ImportData(byteImage, byteImage.length);
			mBloothPrinter.excute();
			mBloothPrinter.ClearData();
			//ͽָ ҪͼƬڴӡַʱ
			byte[] end = { 0x1d, 0x4c, 0x1f, 0x00 };
			mBloothPrinter.ImportData(end, end.length);
			mBloothPrinter.excute();
			mBloothPrinter.ClearData();
*/			
			WifiPrintDriver.printImage();
			
		}
	};

	OnClickListener mBtnPrint1DBarcodeOnClickListener = new OnClickListener() {
		@Override
		public void onClick(View v) {
			if(WifiPrintDriver.IsNoConnection()){
				return;
			}
			WifiPrintDriver.Begin();
			String print1DBarcodeStr = m1DBarcodeContent.getText().toString();
        	int len = print1DBarcodeStr.length();
        	if(len > 16){
        		String tmpString = PrinterOptionActivity.this.getResources().getString(R.string.barcode_input_hint);
    			Utils.ShowMessage(PrinterOptionActivity.this, tmpString);
        		return;
        	}
//        	for(int i=0; i<len; i++){
//        		if(print1DBarcodeStr.charAt(i)<'0' || print1DBarcodeStr.charAt(i)>'9'){
//        			//Utils.ShowMessage(PrinterOptionActivity.this, "ַֻ09λ֮!");
//        			String tmpString = PrinterOptionActivity.this.getResources().getString(R.string.barcode_input_hint);
//        			Utils.ShowMessage(PrinterOptionActivity.this, tmpString);
//            		return;
//            	}
//        	}
        	WifiPrintDriver.AddCodePrint(WifiPrintDriver.Code128_B, print1DBarcodeStr);
        	WifiPrintDriver.excute();
        	WifiPrintDriver.ClearData();
			}
	};

	OnClickListener mBtnPrintTicketOnClickListener = new OnClickListener() {
		@Override
		public void onClick(View v) {
			if(WifiPrintDriver.IsNoConnection()){
				return;
			}
			
			String tmpString1 = PrinterOptionActivity.this.getResources().getString(R.string.print_smallticket_content1);
			String tmpString2 = PrinterOptionActivity.this.getResources().getString(R.string.print_smallticket_content2);
			String tmpString3 = PrinterOptionActivity.this.getResources().getString(R.string.print_smallticket_content3);
			String tmpString4 = PrinterOptionActivity.this.getResources().getString(R.string.print_smallticket_content4);
			String tmpString5 = PrinterOptionActivity.this.getResources().getString(R.string.print_smallticket_content5);
			String tmpString6 = PrinterOptionActivity.this.getResources().getString(R.string.print_smallticket_content6);
			String tmpString7 = PrinterOptionActivity.this.getResources().getString(R.string.print_smallticket_content7);
			String tmpString8 = PrinterOptionActivity.this.getResources().getString(R.string.print_smallticket_content8);
			String tmpString9 = PrinterOptionActivity.this.getResources().getString(R.string.print_smallticket_content9);
			String tmpString10 = PrinterOptionActivity.this.getResources().getString(R.string.print_smallticket_content10);
			String tmpString11 = PrinterOptionActivity.this.getResources().getString(R.string.print_smallticket_content11);
			
			
			String tmpString12 = PrinterOptionActivity.this.getResources().getString(R.string.print_ticket_line1);
			String tmpString13 = PrinterOptionActivity.this.getResources().getString(R.string.print_ticket_line2);
			
			
			WifiPrintDriver.Begin();
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.AddAlignMode((byte)1);//
			WifiPrintDriver.SetLineSpace((byte)50);	
			WifiPrintDriver.SetZoom((byte)0x11);//ߣ		
			WifiPrintDriver.ImportData(tmpString1);
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.AddAlignMode((byte)0);//		
			WifiPrintDriver.SetZoom((byte)0x00);//ĬϿȡĬϸ߶
			WifiPrintDriver.ImportData(tmpString2);
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.ImportData(tmpString3);
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.ImportData(tmpString4);
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.ImportData(tmpString12);
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.ImportData(tmpString5);
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.ImportData(tmpString12);
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.ImportData(tmpString6);
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.ImportData(tmpString7);
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.ImportData(tmpString12);
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.ImportData(tmpString8);
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.SetZoom((byte)0x11);//ߣ	
			WifiPrintDriver.ImportData(tmpString9);
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.ImportData(tmpString13);
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.ImportData(tmpString10);
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.SetZoom((byte)0x00);//ĬϿȡĬϸ߶	
			WifiPrintDriver.ImportData(tmpString11);
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
			WifiPrintDriver.LF();
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
		}
	};

	OnClickListener mBtnPrintTableOnClickListener = new OnClickListener() {
		@Override
		public void onClick(View v) {
			if(WifiPrintDriver.IsNoConnection()){
				return;
			}
			String tmpString1 = PrinterOptionActivity.this.getResources().getString(R.string.print_table_content1);
			String tmpString2 = PrinterOptionActivity.this.getResources().getString(R.string.print_table_content2);
			String tmpString3 = PrinterOptionActivity.this.getResources().getString(R.string.print_table_content3);
			String tmpString4 = PrinterOptionActivity.this.getResources().getString(R.string.print_table_content4);
			String tmpString5 = PrinterOptionActivity.this.getResources().getString(R.string.print_table_content5);
			String tmpString6 = PrinterOptionActivity.this.getResources().getString(R.string.print_table_content6);
			String tmpString7 = PrinterOptionActivity.this.getResources().getString(R.string.print_table_content7);
			String tmpString8 = PrinterOptionActivity.this.getResources().getString(R.string.print_table_content8);
			String tmpString9 = PrinterOptionActivity.this.getResources().getString(R.string.print_table_content9);

		    String language = getLanguageEnv();//ȡǰϵͳ
		    if (language != null  
		            && (language.trim().equals("zh-CN") || language.trim().equals("zh-TW")))  
		    {//
		    	WifiPrintDriver.Begin();
				WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);	//ñ
				WifiPrintDriver.ImportData(String.format(tmpString1),true);
				WifiPrintDriver.ImportData(String.format(tmpString2),true);
				WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01},3);	//ò
				WifiPrintDriver.ImportData(String.format(tmpString3),true);
				WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);	//ñ
				WifiPrintDriver.ImportData(String.format(tmpString4),true);
				WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01},3);	//ò
				WifiPrintDriver.ImportData(String.format(tmpString5), true);
				WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01},3);	//ñ
				WifiPrintDriver.ImportData(String.format(tmpString6),true);
				WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01},3);	//ò
				WifiPrintDriver.ImportData(String.format(tmpString7),true);
				WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01},3);	//ñ
				WifiPrintDriver.ImportData(String.format(tmpString8),true);
				WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x00},3);	//ò
				WifiPrintDriver.ImportData(String.format(tmpString9),true);
				WifiPrintDriver.LF();
				WifiPrintDriver.LF();
				WifiPrintDriver.excute();
				WifiPrintDriver.ClearData();
		    }
		    else  
		    {// Ӣ
		    	WifiPrintDriver.Begin();
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);	//ñ
				// һ
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xDA},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x51}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC2},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x71}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC2},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x11}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC2},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x51}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xBF,0x0A},2);// 
				// ڶ
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3},1);// 
				WifiPrintDriver.ImportData(String.format("From  "),true);
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3},1);// 
				WifiPrintDriver.ImportData(String.format("Shanghai"),true);
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3},1);// 
				WifiPrintDriver.ImportData(String.format("To"),true);
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3},1);// 
				WifiPrintDriver.ImportData(String.format("Xiamen"),true);
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3,0x0A},2);
				// 
				WifiPrintDriver.ImportData(new byte[]{(byte)0xC3},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x51}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC5},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x31}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC2},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x21}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC1},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC2},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC1},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x51}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4},1);// 
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xB4,0x0A},2);// 
				//
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3},1);
				WifiPrintDriver.ImportData(String.format("Amount"),true);
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3},1);
				WifiPrintDriver.ImportData(String.format(" 1  "),true);
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3},1);
				WifiPrintDriver.ImportData(String.format("No. "),true);
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3},1);
				WifiPrintDriver.ImportData(String.format("5555555 "),true);
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3,0x0A},2);
				//
				WifiPrintDriver.ImportData(new byte[]{(byte)0xC3},1);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x51}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4},1);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC1},1);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x21}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4},1);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC2},1);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC1},1);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x31}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4},1);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC1},1);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x71}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4},1);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xB4,0x0A},2);	
				//
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3},1);
				WifiPrintDriver.ImportData(String.format("Addressee "),true);
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3},1);
				WifiPrintDriver.ImportData(String.format("Sun Jun       "),true);
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3,0x0A},2);
				//
				WifiPrintDriver.ImportData(new byte[]{(byte)0xC3},1);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x41}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4,(byte)0xC4},2);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC5},1);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x61}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4,(byte)0xC4},2);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xB4,0x0A},2);    	
				//ڰ
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3},1);
				WifiPrintDriver.ImportData(String.format("Pickup by "),true);
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3},1);
				WifiPrintDriver.ImportData(String.format("              "),true);
				WifiPrintDriver.ImportData(new byte[]{(byte)0xB3,0x0A},2);
				//ھ
				WifiPrintDriver.ImportData(new byte[]{(byte)0xC0},1);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x41}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4,(byte)0xC4},2);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC1},1);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x61}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xC4,(byte)0xC4},2);
		    	WifiPrintDriver.ImportData(new byte[]{0x1d,0x21,0x01}, 3);
		    	WifiPrintDriver.ImportData(new byte[]{(byte)0xD9,0x0A},2);  
				//
				WifiPrintDriver.LF();
				WifiPrintDriver.LF();
				WifiPrintDriver.excute();
				WifiPrintDriver.ClearData();
		    }
		}
	};
}
